import { world } from '@minecraft/server';

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockComponentRegistry.registerCustomComponent('dg:loader', {
        onTick(e) {
            const block = e.block;
            const dim = block.dimension;
            const loc = block.location;

            const nearby = dim.getPlayers({ location: loc, maxDistance: 64 });
            if (nearby.length > 0) return;

            const spawnX = loc.x;
            const spawnY = loc.y - 1;
            const spawnZ = loc.z;

            let cmd = '';
            switch (block.typeId) {
                case 'dg:ironfarm_loader':
                    cmd = `summon iron_golem ${spawnX} ${spawnY} ${spawnZ}`;
                    break;

                case 'dg:goldfarm_loader':
                    cmd = `summon zombie_pigman ${spawnX} ${spawnY} ${spawnZ}`;
                    break;

               // case 'tunekeshi:creeper_farm':
                   // cmd = `summon creeper ${spawnX} ${spawnY} ${spawnZ}`;
                    //break;
                default:
                    return;
            }

            if (cmd) {
                dim.runCommandAsync(cmd);
            }
        }
    });
});
